package cn.com.duiba.cloud.stock.service.api.param;

import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 公共用户param
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @date 2021/12/23 9:31 下午
 * @since 0.0.1
 **/
@Data
@Accessors(chain = true)
public class BaseUserParam implements Serializable {
    private static final long serialVersionUID = 7892192179131157118L;

    /**
     * 用户ID
     */
    @NotNull(message = "用户id不能为空")
    private Long userId;

    /**
     * 用户类型(1:平台;2:租户;3:供应商)
     */
    @NotNull(message = "用户类型不能为空")
    private Integer userType;
}