package cn.com.duiba.cloud.stock.service.api.param.channel;

import cn.com.duiba.wolf.entity.PageRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * sku渠道查询请求参数
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @date 2021/12/22 10:20 上午
 * @since 0.0.1
 **/
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
public class SkuChannelQueryParam extends PageRequest implements Serializable {
    private static final long serialVersionUID = -1373658902637832839L;

    /**
     * spuId
     */
    @NotNull(message = "spuId不能为空")
    private Long spuId;

    /**
     * 用户ID
     */
    @NotNull(message = "用户id不能为空")
    private Long userId;

    /**
     * 用户类型(1:平台;2:租户;3:供应商)
     */
    @NotNull(message = "用户类型不能为空")
    private Integer userType;

    /**
     * spu渠道Id
     */
    private Long spuChannelId;
}