package cn.com.duiba.cloud.stock.service.api.param.occupy;

import cn.com.duiba.cloud.stock.service.api.enums.stock.StockOccupyEnum;
import cn.com.duiba.cloud.stock.service.api.param.BaseUserParam;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 返还预占库存请求参数
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @date 2021/12/17 5:40 下午
 * @since 0.0.1
 **/
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
public class RollbackOccupyStockParam extends BaseUserParam implements Serializable {
    private static final long serialVersionUID = -5909421412751718877L;

    /**
     * 调度作用域id 如活动id
     */
    @NotNull(message = "预占泛id不能为空")
    private Long generalId;

    /**
     * 调度作用域类型 {@link StockOccupyEnum}
     */
    @NotNull(message = "预占类型不能为空")
    private Integer generalType;
}