package cn.com.duiba.cloud.stock.service.api.param.stock;

import cn.com.duiba.cloud.stock.service.api.enums.stock.StockFlowTypeEnum;
import cn.com.duiba.cloud.stock.service.api.enums.stock.StockOccupyEnum;
import cn.com.duiba.cloud.stock.service.api.param.BaseUserParam;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 消耗库存请求参数
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 1.0
 * @date 2021/11/25 4:52 下午
 **/
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
public class ConsumeStockParam extends BaseUserParam implements Serializable {
    private static final long serialVersionUID = 7189730764651444236L;

    /**
     * 预占场景泛id，如活动id<br>
     * 如果是预占消耗库存，必填
     */
    private Long generalId;

    /**
     * 预占场景泛类型，{@link StockOccupyEnum}<br>
     * 如果是预占消耗库存，必填
     */
    private Integer generalType;

    /**
     * skuId
     */
    @NotNull(message = "skuId不能为空")
    private Long skuId;

    /**
     * 库存变更值
     */
    @NotNull(message = "库存变更值不能为空")
    private Long changeValue;

    /**
     * 业务单号
     */
    @NotNull(message = "业务单号不能为空")
    private String bizNo;

    /**
     * 业务类型 {@link StockFlowTypeEnum}
     */
    @NotNull(message = "业务类型不能为空")
    private Integer bizType;
}