package cn.com.duiba.cloud.stock.service.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.stock.service.api.dto.stock.StockOccupyGeneralInfoDTO;
import cn.com.duiba.cloud.stock.service.api.param.occupy.RollbackOccupyStockParam;
import cn.com.duiba.cloud.stock.service.api.param.stock.BackOccupyStockParam;
import cn.com.duiba.cloud.stock.service.api.param.stock.EditOccupyStockParam;
import cn.com.duiba.cloud.stock.service.api.param.stock.StockOccupyGeneralInfoParam;
import cn.com.duiba.cloud.stock.service.api.param.stock.UpdateOccupyStockParam;
import cn.com.duiba.wolf.entity.PageResponse;

import java.util.List;

/**
 * 预占库存remote接口
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @date 2021/12/17 5:38 下午
 * @since 0.0.1
 **/
@AdvancedFeignClient
public interface RemoteStockOccupyService {

    /**
     * 根据预占场景id和类型返还预占库存
     *
     * @param rollbackOccupyStockParam 返还预占库存请求参数
     * @return true/false
     * @throws BizException 业务异常
     *                      <ul>
     *                          <li>计量不存在</li>
     *                          <li>达到上限</li>
     *                          <li>达到下限</li>
     *                      </ul>
     */
    Boolean rollbackOccupyStock(RollbackOccupyStockParam rollbackOccupyStockParam) throws BizException;

    /**
     * 编辑预占库存<br>
     * 新增、减少、删除预占库存都支持
     * <p>
     * 场景:<br>
     * 新增sku:{@link UpdateOccupyStockParam#updateOccupyStockSubParamList}在原有的预占列表上新增,
     * 同时{@link UpdateOccupyStockParam.UpdateOccupyStockSubParam#dispatchValue}必修大于等于0<br>
     * 原有sku新增:{@link UpdateOccupyStockParam.UpdateOccupyStockSubParam#changeValue}必须大于0<br>
     * 原有sku减少:{@link UpdateOccupyStockParam.UpdateOccupyStockSubParam#changeValue}必须小于0<br>
     * 删除sku，即将预占库存全部回退到库存中心:{@link UpdateOccupyStockParam#updateOccupyStockSubParamList}
     * 在原有的预占列表上减少,如果要删除所有预占库存，传空数组即可
     * </p>
     *
     * @param updateOccupyStockParam 编辑预占库存请求参数
     * @return 清除的skuId列表（预占库存为0视为清除）
     * @throws BizException 业务异常
     *                      <ul>
     *                          <li>调度值和变更值不能同时为空</li>
     *                          <li>新增预占库存时，调度值不能为空或不能小于0</li>
     *                          <li>通过skuId:[{}]无法获取库存信息</li>
     *                          <li>db异常</li>
     *                          <li>修改预占库存时，变更值不能为空</li>
     *                          <li>根据库存id:[{}]无法获取库存</li>
     *                          <li>编辑预占库存请求子参数列表不能为空</li>
     *                      </ul>
     */
    @Deprecated
    List<Long> updateOccupyStock(UpdateOccupyStockParam updateOccupyStockParam) throws BizException;

    /**
     * 编辑预占库存
     *
     * @param editOccupyStockParam 编辑预占库存请求参数
     * @return true/false
     * @throws BizException 业务异常
     */
    Boolean editOccupyStock(EditOccupyStockParam editOccupyStockParam) throws BizException;

    /**
     * 分页查询预占列表库存信息
     *
     * @param stockOccupyGeneralInfoParam 请求参数
     * @return 预占列表库存信息
     * @throws BizException 业务异常
     *                      <ul>
     *                          <li>分页参数不能为空</li>
     *                          <li>库存id列表不能为空</li>
     *                          <li>bizNoList不能为空</li>
     *                      </ul>
     */
    PageResponse<StockOccupyGeneralInfoDTO> pageListStockOccupyGeneralInfo(StockOccupyGeneralInfoParam stockOccupyGeneralInfoParam) throws BizException;

    /**
     * 返还预占库存
     *
     * @param backOccupyStockParam 返还预占库存请求参数
     * @return 预占库存清算到0的skuId列表
     * @throws BizException 业务异常
     */
    List<Long> backOccupyStock(BackOccupyStockParam backOccupyStockParam) throws BizException;
}