package cn.com.duiba.cloud.stock.service.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.stock.service.api.dto.stock.ConsumeStockResultDTO;
import cn.com.duiba.cloud.stock.service.api.dto.stock.StockInfoDTO;
import cn.com.duiba.cloud.stock.service.api.param.stock.BatchGetStockInfoParam;
import cn.com.duiba.cloud.stock.service.api.param.stock.ConsumeStockParam;
import cn.com.duiba.cloud.stock.service.api.param.stock.UpdateStockStatusParam;

import java.util.List;

/**
 * 库存中心remote接口
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 1.0
 * @date 2021/11/20 1:33 下午
 **/
@AdvancedFeignClient
public interface RemoteStockService {
    /**
     * 通过skuId列表批量获取可销售库存信息
     *
     * @param batchGetStockInfoParam 批量获取可销售库存请求参数
     * @return 库存信息
     */
    List<StockInfoDTO> batchGetStockInfo(BatchGetStockInfoParam batchGetStockInfoParam);

    /**
     * 批量消耗库存
     *
     * @param consumeStockParamList 消耗库存请求参数列表
     * @return 变更库存结果
     * @throws BizException 业务异常
     *                      <ul>
     *                          <li>预占场景id和预占类型不能为空</li>
     *                          <li>通过预占场景id:[{}]、skuId:[{}]无法获取预占库存信息</li>
     *                          <li>消耗预占库存，通过计量id无法匹配预占库存</li>
     *                          <li>通过库存id:[{}]无法获取批次库存信息</li>
     *                          <li>db异常</li>
     *                          <li>通过skuId:[{}]无法获取库存信息</li>
     *                          <li>消耗销售库存，通过计量id无法匹配库存</li>
     *                      </ul>
     */
    List<ConsumeStockResultDTO> consumeStock(List<ConsumeStockParam> consumeStockParamList) throws BizException;

    /**
     * 批量修改库存状态
     *
     * @param updateStockStatusParam 修改库存状态请求参数
     * @return true/false
     * @throws BizException 业务异常
     *                      <ul>
     *                          <li>批量修改库存状态不能为冻结</li>
     *                          <li>通过业务单号:[{}],业务类型:[{}]无法获取库存流水</li>
     *                          <li>db异常</li>
     *                          <li>通过库存id:[{}]无法获取库存信息</li>
     *                          <li>通过库存批次id:[{}]无法获取批次库存信息</li>
     *                      </ul>
     */
    Boolean batchUpdateStockStatus(UpdateStockStatusParam updateStockStatusParam) throws BizException;
}