package cn.com.duiba.cloud.stock.service.api.dto.stock;

import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * 真实库存信息
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 1.0
 * @date 2021/12/4 1:43 下午
 **/
@Data
@Accessors(chain = true)
public class StockInfoDTO implements Serializable {
    private static final long serialVersionUID = -2702906453314210913L;

    /**
     * skuId
     */
    private Long skuId;

    /**
     * 可用库存
     */
    private Long canSaleStockNumber;

    /**
     * 占用库存
     */
    private Long occupyStockNumber;

    /**
     * 总库存
     */
    private Long totalStockNumber;

    public Long getTotalStockNumber() {
        return canSaleStockNumber + occupyStockNumber;
    }
}
