package cn.com.duiba.cloud.stock.service.api.exception;

import cn.com.duiba.cloud.biz.tool.message.ErrorMeta;

/**
 * 库存错误
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @date 2021/12/29 11:33 上午
 * @since 0.0.1
 **/
public interface StockError {
    String STOCK_ISV = "stock.error_";

    ErrorMeta OCCUPY_SCENE_TYPE_ERROR = new ErrorMeta(STOCK_ISV, "40001", "预占场景类型错误");
    ErrorMeta GET_OCCUPY_STOCK_IS_NULL = new ErrorMeta(STOCK_ISV, "40002", "获取预占库存为空");
    ErrorMeta CONSUME_OCCUPY_STOCK_EXCEPTION = new ErrorMeta(STOCK_ISV, "40003", "消耗预占库存异常");
    /**
     * {0}({1})获取批次库存为空
     */
    ErrorMeta GET_LOT_STOCK_IS_NULL = new ErrorMeta(STOCK_ISV, "40004", "获取批次库存为空");
    /**
     * {0}({1})获取库存为空
     */
    ErrorMeta GET_STOCK_IS_NULL = new ErrorMeta(STOCK_ISV, "40005", "获取预占库存为空");
    ErrorMeta CONSUME_ORDER_STOCK_EXCEPTION = new ErrorMeta(STOCK_ISV, "40006", "消耗订单库存异常");
    /**
     * {0}参数有误
     */
    ErrorMeta PARAM_IS_ERROR = new ErrorMeta(STOCK_ISV, "40007", "参数有误");
    ErrorMeta STOCK_NUMBER_NOT_MATCH = new ErrorMeta(STOCK_ISV, "40008", "总库存和批次库存不匹配");
    ErrorMeta UPDATE_STOCK_EXCEPTION = new ErrorMeta(STOCK_ISV, "40009", "修改库存异常");
    ErrorMeta STOCK_FLOW_TYPE_INVALID = new ErrorMeta(STOCK_ISV, "40010", "库存流水类型非法");
    /**
     * {0}({1})获取库存流水为空
     */
    ErrorMeta GET_STOCK_FLOW_IS_NULL = new ErrorMeta(STOCK_ISV, "40011", "获取库存流水为空");
    ErrorMeta LOT_STOCK_NUMBER_IS_NULL_OR_LT_ZERO = new ErrorMeta(STOCK_ISV, "40012", "批次库存数量为空或小于0");
    /**
     * 超过sku上限:{0}
     */
    ErrorMeta SKU_LIMIT = new ErrorMeta(STOCK_ISV, "40013", "超过sku上限");
    /**
     * 超过spu上限:{0}
     */
    ErrorMeta SPU_LIMIT = new ErrorMeta(STOCK_ISV, "40014", "超过spu上限");
}