package cn.com.duiba.cloud.stock.service.api.param.stock;

import cn.com.duiba.cloud.stock.service.api.enums.stock.StockOccupyEnum;
import cn.com.duiba.cloud.stock.service.api.param.BaseAppParam;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * 返还预占库存请求参数
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 1.0
 * @date 2021/12/25 4:04 下午
 **/
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
public class BackOccupyStockParam extends BaseAppParam implements Serializable {
    private static final long serialVersionUID = -6882943090626971560L;

    /**
     * 调度作用域id 如活动id
     */
    @NotNull(message = "预占泛id不能为空")
    private Long generalId;

    /**
     * 调度作用域类型 {@link StockOccupyEnum}
     */
    @NotNull(message = "预占类型不能为空")
    private Integer generalType;

    /**
     * 返还预占库存子参数
     */
    @NotNull(message = "返还预占库存子参数不能为空")
    private List<BackOccupyStockSubParam> backOccupyStockSubParamList;

    @Data
    @Accessors(chain = true)
    public static class BackOccupyStockSubParam implements Serializable {
        private static final long serialVersionUID = -5717827377328818952L;

        /**
         * skuId
         */
        @NotNull(message = "skuId不能为空")
        private Long skuId;

        /**
         * 返还值，正数
         */
        @NotNull(message = "返还值不能为空")
        private Long backValue;
    }
}
