package cn.com.duiba.cloud.stock.service.api.param.stock;

import cn.com.duiba.cloud.stock.service.api.param.BaseAppParam;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * 批量获取可销售库存请求参数
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @date 2021/12/24 12:08 下午
 * @since 0.0.1
 **/
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
public class BatchGetStockInfoParam extends BaseAppParam implements Serializable {
    private static final long serialVersionUID = -8426795288504162389L;

    /**
     * skuId列表
     */
    @NotNull(message = "skuId列表不能为空")
    private List<Long> skuIdList;
}