package cn.com.duiba.cloud.stock.service.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.stock.service.api.dto.stock.StockOccupyGeneralInfoDTO;
import cn.com.duiba.cloud.stock.service.api.exception.ChannelError;
import cn.com.duiba.cloud.stock.service.api.exception.OccupyError;
import cn.com.duiba.cloud.stock.service.api.exception.StockError;
import cn.com.duiba.cloud.stock.service.api.param.occupy.RollbackOccupyStockParam;
import cn.com.duiba.cloud.stock.service.api.param.stock.BackOccupyStockParam;
import cn.com.duiba.cloud.stock.service.api.param.stock.EditOccupyStockParam;
import cn.com.duiba.cloud.stock.service.api.param.stock.StockOccupyGeneralInfoParam;
import cn.com.duiba.wolf.entity.PageResponse;

import java.util.List;

/**
 * 预占库存remote接口
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @date 2021/12/17 5:38 下午
 * @since 0.0.1
 **/
@AdvancedFeignClient
public interface RemoteStockOccupyService {

    /**
     * 根据预占场景id和类型返还预占库存
     *
     * @param rollbackOccupyStockParam 返还预占库存请求参数
     * @return true/false
     * @throws BizException 业务异常 {@link ChannelError},{@link StockError},{@link OccupyError}
     */
    Boolean rollbackOccupyStock(RollbackOccupyStockParam rollbackOccupyStockParam) throws BizException;

    /**
     * 编辑预占库存
     *
     * @param editOccupyStockParam 编辑预占库存请求参数
     * @return true/false
     * @throws BizException 业务异常 {@link ChannelError},{@link StockError},{@link OccupyError}
     */
    Boolean editOccupyStock(EditOccupyStockParam editOccupyStockParam) throws BizException;

    /**
     * 分页查询预占列表库存信息
     *
     * @param stockOccupyGeneralInfoParam 请求参数
     * @return 预占列表库存信息
     * @throws BizException 业务异常 {@link ChannelError},{@link StockError},{@link OccupyError}
     */
    PageResponse<StockOccupyGeneralInfoDTO> pageListStockOccupyGeneralInfo(StockOccupyGeneralInfoParam stockOccupyGeneralInfoParam) throws BizException;

    /**
     * 返还预占库存<br>
     * 如果backValue为0，且库存中心存在预占库存，将会逻辑删除对应的预占库存
     *
     * @param backOccupyStockParam 返还预占库存请求参数
     * @return 预占库存清算到0的skuId列表
     * @throws BizException 业务异常 {@link ChannelError},{@link StockError},{@link OccupyError}
     */
    List<Long> backOccupyStock(BackOccupyStockParam backOccupyStockParam) throws BizException;
}