package cn.com.duiba.cloud.stock.service.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.stock.service.api.dto.stock.ConsumeStockResultDTO;
import cn.com.duiba.cloud.stock.service.api.dto.stock.SpuStockInfoDTO;
import cn.com.duiba.cloud.stock.service.api.dto.stock.StockInfoDTO;
import cn.com.duiba.cloud.stock.service.api.exception.ChannelError;
import cn.com.duiba.cloud.stock.service.api.exception.OccupyError;
import cn.com.duiba.cloud.stock.service.api.exception.StockError;
import cn.com.duiba.cloud.stock.service.api.param.stock.BatchGetStockInfoParam;
import cn.com.duiba.cloud.stock.service.api.param.stock.ConsumeStockParam;
import cn.com.duiba.cloud.stock.service.api.param.stock.StockParam;
import cn.com.duiba.cloud.stock.service.api.param.stock.UpdateStockStatusParam;

import java.util.List;

/**
 * 库存中心remote接口
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 1.0
 * @date 2021/11/20 1:33 下午
 **/
@AdvancedFeignClient
public interface RemoteStockService {
    /**
     * 通过spuId列表批量查询总库存<br>
     * spuId每次最多支持20个
     *
     * @param spuIdList spuId
     * @return spu总库存信息
     * @throws BizException 业务异常 {@link StockError}
     */
    List<SpuStockInfoDTO> batchGetSpuStockInfo(List<Long> spuIdList) throws BizException;

    /**
     * 通过skuId列表批量获取库存信息<br>
     * skuId列表最大支持50
     *
     * @param batchGetStockInfoParam 批量获取可销售库存请求参数
     * @return 库存信息
     * @throws BizException 业务异常 {@link StockError}
     */
    List<StockInfoDTO> batchGetStockInfo(BatchGetStockInfoParam batchGetStockInfoParam) throws BizException;

    /**
     * 创建库存
     *
     * @param stockParam 创建库存请求参数
     * @return 库存id列表
     * @throws BizException 业务异常 {@link StockError}
     */
    List<Long> createStock(StockParam stockParam) throws BizException;

    /**
     * 修改库存
     *
     * @param stockParam 修改库存请求参数
     * @throws BizException 业务异常 {@link StockError}
     */
    void updateStock(StockParam stockParam) throws BizException;

    /**
     * 批量消耗库存
     *
     * @param consumeStockParamList 消耗库存请求参数列表
     * @return 变更库存结果
     * @throws BizException 业务异常 {@link ChannelError},{@link StockError},{@link OccupyError}
     */
    List<ConsumeStockResultDTO> consumeStock(List<ConsumeStockParam> consumeStockParamList) throws BizException;

    /**
     * 批量修改库存状态
     *
     * @param updateStockStatusParam 修改库存状态请求参数
     * @return true/false
     * @throws BizException 业务异常 {@link ChannelError},{@link StockError},{@link OccupyError}
     */
    Boolean batchUpdateStockStatus(UpdateStockStatusParam updateStockStatusParam) throws BizException;
}