package cn.com.duiba.cloud.stock.service.api.param.occupy;

import lombok.Data;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.List;

/**
 * 批量检查sku是否含有预占库存请求参数
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @date 2022/1/14 6:10 下午
 * @since 0.0.1
 **/
@Data
public class CheckSkuHasOccupyParam implements Serializable {
    private static final long serialVersionUID = 8428156930842353895L;

    /**
     * skuId列表
     */
    @NotNull(message = "skuId列表不能为空")
    @Size(min = 1, max = 50, message = "skuId列表不能为空")
    private List<Long> skuIdList;
}