package cn.com.duiba.cloud.stock.service.api.param.stock;

import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.List;

/**
 * 批量获取spu总库存请求参数
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @date 2021/12/24 12:08 下午
 * @since 0.0.1
 **/
@Data
@Accessors(chain = true)
public class BatchGetSpuStockInfoParam implements Serializable {
    private static final long serialVersionUID = -8426795288504162389L;

    /**
     * spuId列表
     */
    @Valid
    @NotNull(message = "spuId列表不能为空")
    @Size(min = 1, max = 20, message = "spuIdId列表大小必须在1-20之间")
    private List<GetSpuStockInfoParam> getSpuStockInfoParamList;
}