package cn.com.duiba.cloud.stock.service.api.param.stock;

import cn.com.duiba.cloud.stock.service.api.enums.stock.StockFlowTypeEnum;
import cn.com.duiba.cloud.stock.service.api.enums.stock.StockOccupyEnum;
import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.List;

/**
 * 消耗库存请求参数
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 1.0
 * @date 2021/11/25 4:52 下午
 **/
@Data
@Accessors(chain = true)
public class ConsumeStockParam implements Serializable {
    private static final long serialVersionUID = 7189730764651444236L;

    @Valid
    @NotNull(message = "消耗库存不能为空")
    @Size(min = 1, max = 50, message = "批量消耗库存范围只能为1-50")
    private List<ConsumeStockSubParam> consumeStockSubParamList;

    @Data
    @Accessors(chain = true)
    public static class ConsumeStockSubParam implements Serializable {
        private static final long serialVersionUID = -5715151934362507741L;

        /**
         * 应用ID
         */
        @NotNull(message = "应用id不能为空")
        private Long appId;

        /**
         * 预占场景泛id，如活动id<br>
         * 如果是预占消耗库存，必填
         */
        private Long generalId;

        /**
         * 预占场景泛类型，{@link StockOccupyEnum}<br>
         * 如果是预占消耗库存，必填
         */
        private Integer generalType;

        /**
         * skuId
         */
        @NotNull(message = "skuId不能为空")
        private Long skuId;

        /**
         * 库存变更值
         */
        @NotNull(message = "库存变更值不能为空")
        @Max(value = -1)
        private Long changeValue;

        /**
         * 业务单号
         */
        @NotBlank(message = "业务单号不能为空")
        private String bizNo;

        /**
         * 业务类型 {@link StockFlowTypeEnum}
         */
        @NotNull(message = "业务类型不能为空")
        @Min(value = 1, message = "库存流水类型非法")
        @Max(value = 6, message = "库存流水类型非法")
        private Integer bizType;
    }
}