package cn.com.duiba.cloud.stock.service.api.param.stock;

import cn.com.duiba.cloud.stock.service.api.param.BaseAppParam;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.List;

/**
 * 修改库存请求参数
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 1.0
 * @date 2021/11/23 4:40 下午
 **/
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
public class StockParam extends BaseAppParam implements Serializable {
    private static final long serialVersionUID = 6194304768696006981L;

    /**
     * spuId
     */
    @NotNull(message = "spuId不能为空")
    private Long spuId;

    /**
     * 创建库存请求参数
     */
    @Valid
    @NotNull(message = "库存子参数不能为空")
    @Size(min = 1, max = 50, message = "批量只能创建1-50个sku")
    private List<StockSubParam> stockSubParamList;

    @Data
    @Accessors(chain = true)
    public static class StockSubParam implements Serializable {
        private static final long serialVersionUID = -1953778856263940643L;

        /**
         * skuID
         */
        @NotNull(message = "skuId不能为空")
        private Long skuId;

        /**
         * 新增时初始库存数量
         */
        private Long initNumber;

        /**
         * 修改时变更库存数量
         */
        private Long changeNumber;

        /**
         * 成本价（分）
         */
        private Long costPrice;

        /**
         * 是否批次管理(1:是,0:否)
         */
        @NotNull(message = "是否批次管理标识不能为空")
        @Min(value = 0, message = "是否批次管理标识错误")
        @Max(value = 1, message = "是否批次管理标识错误")
        private Integer isLot;

        /**
         * 创建/修改批次库存请求参数
         */
        private List<StockLotParam> stockLotParamList;
    }
}