package cn.com.duiba.cloud.stock.service.api.param.stock;

import cn.com.duiba.cloud.stock.service.api.enums.stock.StockFlowStatusEnum;
import cn.com.duiba.cloud.stock.service.api.enums.stock.StockFlowTypeEnum;
import cn.com.duiba.cloud.stock.service.api.param.BaseAppParam;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.List;

/**
 * 修改库存状态请求参数
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 1.0
 * @date 2021/11/29 4:43 下午
 **/
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
public class UpdateStockStatusParam extends BaseAppParam implements Serializable {
    private static final long serialVersionUID = -8594099608017993959L;

    @Valid
    @NotNull(message = "修改库存状态子参数不能为空")
    @Size(min = 1,message = "修改库存状态子参数不能为空")
    private List<UpdateStockStatusSubParam> updateStockStatusSubParamList;

    @Data
    @Accessors(chain = true)
    public static class UpdateStockStatusSubParam implements Serializable {
        private static final long serialVersionUID = 4351340710339755324L;

        /**
         * 业务单号
         */
        @NotBlank(message = "业务单号不能为空")
        private String bizNo;

        /**
         * 业务类型 {@link StockFlowTypeEnum}
         */
        @NotNull(message = "业务类型不能为空")
        private Integer bizType;

        /**
         * 变更的库存状态 {@link StockFlowStatusEnum}
         */
        @NotNull(message = "库存流水状态不能为空")
        @Min(value = 1, message = "库存流水状态错误")
        @Max(value = 4, message = "库存流水状态错误")
        private Integer stockStatus;
    }
}