package cn.com.duiba.cloud.stock.service.api.enums.stock;

import cn.com.duiba.cloud.biz.tool.enums.IEnum;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 库存预占类型枚举
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 1.0
 * @date 2021/11/25 2:21 下午
 **/
@Getter
@AllArgsConstructor
public enum StockOccupyEnum implements IEnum<Integer> {
    /**
     * 活动预占
     */
    ACTIVITY("活动", 1),
    /**
     * 独占
     */
    MONOPOLIZE("独占",2),
    ;

    /**
     * 描述
     */
    private String desc;

    /**
     * db值
     */
    private Integer dbCode;
}