package cn.com.duiba.cloud.stock.service.api.exception;

import cn.com.duiba.cloud.biz.tool.message.ErrorMeta;

/**
 * 预占错误
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @date 2021/12/29 8:48 下午
 * @since 0.0.1
 **/
public interface OccupyError {
    String OCCUPY_ISV = "occupy.error_";

    ErrorMeta OCCUPY_LOCK = new ErrorMeta(OCCUPY_ISV, "130201", "触发预占库存锁");
    /**
     * {0}({1})不存在预占，无法变更操作
     */
    ErrorMeta OCCUPY_CHANGE_ERROR = new ErrorMeta(OCCUPY_ISV, "130202", "不存在预占，无法变更操作");
    /**
     * {0}({1})没有自有库存或没有独占库存
     */
    ErrorMeta NO_SELF_STOCK_OR_NO_MONOPOLIZE_STOCK = new ErrorMeta(OCCUPY_ISV, "130203", "没有自有库存或没有独占库存");
    /**
     * {0}({1})已经存在独占库存
     */
    ErrorMeta MONOPOLIZE_STOCK_EXIST = new ErrorMeta(OCCUPY_ISV, "130204", "已经存在独占库存");
    /**
     * {0}({1})没有独占库存，无法操作
     */
    ErrorMeta NO_MONOPOLIZE_STOCK = new ErrorMeta(OCCUPY_ISV, "130205", "没有独占库存，无法操作");
    /**
     * {0}({1})存在活动预占库存或冻结库存，无法删除独占库存
     */
    ErrorMeta DELETE_MONOPOLIZE_STOCK_INVALID = new ErrorMeta(OCCUPY_ISV, "130206", "存在活动预占库存或冻结库存，无法删除独占库存");
    /**
     * {0}({1})已经存在活动预占库存
     */
    ErrorMeta ACTIVITY_STOCK_EXIST = new ErrorMeta(OCCUPY_ISV, "130207", "已经存在活动预占库存");
}