package cn.com.duiba.cloud.stock.service.api.param.stock;

import cn.com.duiba.cloud.stock.service.api.param.BaseAppParam;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.List;

/**
 * CMS批量获取库存明细请求参数
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @date 2022-03-26 10:22
 * @since 0.0.6
 **/
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
public class RemoteCmsBatchGetStockInfoParam extends BaseAppParam implements Serializable {
    private static final long serialVersionUID = 6458064615598536494L;

    /**
     * cms批量查询库存明细sku列表
     */
    @Valid
    @NotNull(message = "sku列表不能为空")
    @Size(max = 50, min = 1, message = "sku列表大小必须在1-50之间")
    public List<RemoteCmsBatchGetStockInfoSubParam> skuList;


    @Data
    @Accessors(chain = true)
    public static class RemoteCmsBatchGetStockInfoSubParam implements Serializable {
        private static final long serialVersionUID = 5739543433689015588L;

        /**
         * skuId
         */
        @NotNull(message = "skuId不能为空")
        private Long skuId;

        /**
         * 兑吧是否给开发者开启共享库存
         */
        @NotNull(message = "是否开启共享不能为空")
        private Boolean isEnabledShare;
    }
}
