package cn.com.duiba.cloud.stock.service.api.dto.flow;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 库存流水DTO
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @since 0.0.3
 **/
@Data
public class StockFlowDTO implements Serializable {
    private static final long serialVersionUID = 2928889236650906863L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 流水号
     */
    private String flowNo;

    /**
     * 库存变更数
     */
    private Long stockNumber;

    /**
     * 库存id
     */
    private Long stockId;

    /**
     * 预占库存id
     */
    private Long stockOccupyId;

    /**
     * 库存状态(1:冻结,2:完成,3:失败)
     */
    private Integer stockStatus;

    /**
     * 应用ID
     */
    private Long appId;

    /**
     * 业务单号
     */
    private String bizNo;

    /**
     * 业务类型(1:销售订单,2:库存初始化,3:修改库存,4:调度库存,5:活动订单,6:返库……)
     */
    private Integer bizType;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
}