package cn.com.duiba.cloud.stock.service.api.dto.stock;

import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * 兑吧库存明细DTO
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @date 2022-03-24 10:39
 * @since 0.0.6
 **/
@Data
@Accessors(chain = true)
public class DuibaStockInfoDTO implements Serializable {
    private static final long serialVersionUID = 858636796289889334L;

    /**
     * skuId
     */
    private Long skuId;

    /**
     * 历史总库存
     */
    private Long historyTotalStockNumber;

    /**
     * 剩余总库存
     */
    private Long residueTotalStockNumber;

    /**
     * 历史共享库存
     */
    private Long historyShareStockNumber;

    /**
     * 剩余共享库存
     */
    private Long residueShareStockNumber;

    /**
     * 历史独占库存
     */
    private Long historyMonopolizeStockNumber;

    /**
     * 剩余独占库存
     */
    private Long residueMonopolizeStockNumber;

    /**
     * 已销售库存
     */
    private Long salesStockNumber;
}
