package cn.com.duiba.cloud.stock.service.api.dto.stock;

import cn.hutool.core.util.ObjectUtil;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * 真实库存信息
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 1.0
 * @date 2021/12/4 1:43 下午
 **/
@Data
@Accessors(chain = true)
public class StockInfoDTO implements Serializable {
    private static final long serialVersionUID = -2702906453314210913L;

    /**
     * skuId
     */
    private Long skuId;

    /**
     * 可用库存
     */
    private Long canSaleStockNumber;

    /**
     * 独占库存
     */
    private Long monopolizeStockNumber;

    /**
     * 预占库存（活动）
     */
    private Long activityStockNumber;

    /**
     * 已销售库存
     */
    private Long salesStockNumber;

    /**
     * 冻结库存
     */
    private Long freezeStockNumber;

    /**
     * 总库存
     */
    private Long totalStockNumber;

    public Long getTotalStockNumber() {
        return getMonopolizeStockNumber() + getActivityStockNumber() + getCanSaleStockNumber()
                + getFreezeStockNumber();
    }

    public Long getMonopolizeStockNumber() {
        return ObjectUtil.isNull(monopolizeStockNumber) ? 0L : monopolizeStockNumber;
    }

    public Long getActivityStockNumber() {
        return ObjectUtil.isNull(activityStockNumber) ? 0L : activityStockNumber;
    }
}
