package cn.com.duiba.cloud.stock.service.api.enums.stock;

import cn.com.duiba.cloud.biz.tool.enums.IEnum;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 库存流水状态枚举
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 1.0
 * @date 2021/11/23 5:08 下午
 **/
@Getter
@AllArgsConstructor
public enum StockFlowStatusEnum implements IEnum<Integer> {
    /**
     * 冻结
     */
    FREEZE(1, "冻结", "freeze"),

    /**
     * 成功
     */
    SUCCESS(2, "成功", "success"),

    /**
     * 失败
     */
    FAIL(3, "失败", "fail"),

    /**
     * 售后
     */
    AFTER(4, "售后", "after"),
    ;

    /**
     * 状态id
     */
    private Integer dbCode;

    /**
     * 业务类型描述
     */
    private String desc;

    /**
     * 场景
     */
    private String scene;
}