package cn.com.duiba.cloud.stock.service.api.openapi;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.duiba.openapi.service.api.annotation.OpenApi;
import cn.com.duiba.cloud.duiba.openapi.service.api.annotation.OpenPath;
import cn.com.duiba.cloud.stock.service.api.dto.stock.StockInfoDTO;
import cn.com.duiba.cloud.stock.service.api.exception.StockError;
import cn.com.duiba.cloud.stock.service.api.openapi.param.OpenBatchGetStockInfoParam;
import cn.com.duiba.cloud.stock.service.api.openapi.param.OpenGetStockInfoParam;

import java.util.List;

/**
 * 库存开放接口
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @since 0.0.1
 **/
@OpenApi(prefix = "/stock")
@AdvancedFeignClient
public interface OpenStockService {
    /**
     * 通过skuId单获取库存信息
     *
     * @param openGetStockInfoParam 单获取库存信息请求参数
     * @return 库存信息
     * @throws BizException 业务异常 {@link StockError}
     */
    @OpenPath(apiPath = "/single_get_stock_info", apiDesc = "通过skuId单获取库存信息")
    StockInfoDTO singleGetStockInfo(OpenGetStockInfoParam openGetStockInfoParam) throws BizException;

    /**
     * 通过skuId列表批量获取库存信息<br>
     * skuId列表最大支持50
     *
     * @param openBatchGetStockInfoParam 批量获取库存信息请求参数
     * @return 库存信息
     * @throws BizException 业务异常 {@link StockError}
     */
    @OpenPath(apiPath = "/batch_get_stock_info", apiDesc = "通过skuId列表批量获取库存信息<br>" +
            "skuId列表最大支持50")
    List<StockInfoDTO> batchGetStockInfo(OpenBatchGetStockInfoParam openBatchGetStockInfoParam) throws BizException;
}