package cn.com.duiba.cloud.stock.service.api.param.flow;

import cn.com.duiba.wolf.entity.PageRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 查询库存流水请求参数
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @since 0.0.3
 **/
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
public class RemoteStockFlowParam extends PageRequest implements Serializable {
    private static final long serialVersionUID = -1494065932926560658L;

    @NotNull(message = "skuId不能为空")
    private Long skuId;

    /**
     * 分页查询时，是否需要查询总数<br>
     * 默认false，不查询
     */
    private Boolean isSearchCount = false;
}