package cn.com.duiba.cloud.stock.service.api.param.stock;

import cn.com.duiba.cloud.stock.service.api.param.BaseAppParam;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.List;

/**
 * 清除库存批次请求参数
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @date 2022-04-06 16:09
 * @since 0.0.6
 **/
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
public class RemoteClearStockLotParam extends BaseAppParam implements Serializable {
    private static final long serialVersionUID = 187200090341309659L;

    /**
     * 清除库存批次请求子参数列表
     */
    @NotNull(message = "清除库存批次请求子参数列表不能为空")
    @Size(min = 1, max = 20, message = "清除库存批次请求子参数列表大小必须在1-20之间")
    private List<RemoteClearStockLotSubParam> clearStockLotSubParamList;

    @Data
    @Accessors(chain = true)
    public static class RemoteClearStockLotSubParam implements Serializable {
        private static final long serialVersionUID = -4467871055878729922L;

        /**
         * skuId
         */
        @NotNull(message = "skuId不能为空")
        private Long skuId;

        /**
         * 批次号
         */
        @NotNull(message = "批次号不能为空")
        private Long lotNo;
    }
}
