package cn.com.duiba.cloud.stock.service.api.param.stock;

import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.List;

/**
 * spu对应sku参数
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @date 2022-03-16 10:24
 * @since 0.0.5
 **/
@Data
@Accessors(chain = true)
public class RemoteSpuToSkuParam implements Serializable {
    private static final long serialVersionUID = -3969128449704291675L;

    /**
     * spuId
     */
    @NotNull(message = "spuId不能为空")
    private Long spuId;

    /**
     * skuId列表
     */
    @NotNull(message = "skuId列表不能为空")
    @Size(min = 1, max = 100, message = "skuId列表大小必须在1-100之间")
    private List<Long> skuIdList;
}
