package cn.com.duiba.cloud.stock.service.api.dto.stock;

import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * CMS库存明细DTO
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @date 2022-03-26 10:14
 * @since 0.0.6
 **/
@Data
@Accessors(chain = true)
public class CmsStockInfoDTO implements Serializable {
    private static final long serialVersionUID = 5963393498897883881L;

    /**
     * skuId
     */
    private Long skuId;

    /**
     * 自有库存<br>
     * 开发者自建商品才有，默认为null
     */
    private Long selfStockNumber;

    /**
     * 共享库存<br>
     * 默认有，若兑吧停用了开发者共享库存，为null
     */
    private Long shareStockNumber;

    /**
     * 独占库存<br>
     * 默认为null，若兑吧给开发者分配了独占库存，才有
     */
    private Long monopolizeStockNumber;

    /**
     * 活动预占库存
     */
    private Long activityStockNumber;

    /**
     * 活动订单冻结库存<br>
     * 有活动订单冻结库存才有，默认为null
     */
    private Long freezeStockNumber;
}
