package cn.com.duiba.cloud.stock.service.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.stock.service.api.dto.occupy.ActivityStockInfoDTO;
import cn.com.duiba.cloud.stock.service.api.dto.occupy.CheckSkuHasOccupyDTO;
import cn.com.duiba.cloud.stock.service.api.dto.occupy.StockOccupyGeneralInfoDTO;
import cn.com.duiba.cloud.stock.service.api.dto.stock.GetActivityStockByActivityIdDTO;
import cn.com.duiba.cloud.stock.service.api.exception.OccupyError;
import cn.com.duiba.cloud.stock.service.api.exception.StockError;
import cn.com.duiba.cloud.stock.service.api.param.occupy.BackOccupyStockParam;
import cn.com.duiba.cloud.stock.service.api.param.occupy.CheckSkuHasOccupyParam;
import cn.com.duiba.cloud.stock.service.api.param.occupy.EditOccupyStockParam;
import cn.com.duiba.cloud.stock.service.api.param.occupy.RemoteActivityOccupyInfoParam;
import cn.com.duiba.cloud.stock.service.api.param.occupy.RemoteClearOccupyStockParam;
import cn.com.duiba.cloud.stock.service.api.param.occupy.RemoteEditMonopolizeStockParam;
import cn.com.duiba.cloud.stock.service.api.param.occupy.RemoteGetActivityStockByActivityIdParam;
import cn.com.duiba.cloud.stock.service.api.param.occupy.RollbackOccupyStockParam;
import cn.com.duiba.cloud.stock.service.api.param.occupy.StockOccupyGeneralInfoParam;
import cn.com.duiba.wolf.entity.PageResponse;

import java.util.List;

/**
 * 预占库存remote接口
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @date 2021/12/17 5:38 下午
 * @since 0.0.1
 **/
@AdvancedFeignClient
public interface RemoteStockOccupyService {

    /**
     * 根据预占场景id和类型返还并释放预占库存
     * <br>
     * 目前支持活动预占库存返还
     *
     * @param rollbackOccupyStockParam 返还预占库存请求参数
     * @return true/false
     * @throws BizException 业务异常 {@link StockError},{@link OccupyError}
     */
    Boolean rollbackOccupyStock(RollbackOccupyStockParam rollbackOccupyStockParam) throws BizException;

    /**
     * 编辑活动预占库存
     *
     * @param editOccupyStockParam 编辑预占库存请求参数
     * @return true/false
     * @throws BizException 业务异常 {@link StockError},{@link OccupyError}
     */
    Boolean editOccupyStock(EditOccupyStockParam editOccupyStockParam) throws BizException;

    /**
     * 编辑独占库存
     *
     * @param remoteEditMonopolizeStockParam 编辑独占库存请求参数
     * @return true/false
     * @throws BizException 业务异常 {@link StockError},{@link OccupyError}
     */
    Boolean editMonopolizeStock(RemoteEditMonopolizeStockParam remoteEditMonopolizeStockParam) throws BizException;

    /**
     * 分页查询预占列表库存信息
     *
     * @param stockOccupyGeneralInfoParam 请求参数
     * @return 预占列表库存信息
     * @throws BizException 业务异常 {@link StockError},{@link OccupyError}
     */
    PageResponse<StockOccupyGeneralInfoDTO> pageListStockOccupyGeneralInfo(
            StockOccupyGeneralInfoParam stockOccupyGeneralInfoParam) throws BizException;

    /**
     * 返还预占库存<br>
     * 如果backValue为0，且库存中心存在预占库存，将会逻辑删除对应的预占库存
     *
     * @param backOccupyStockParam 返还预占库存请求参数
     * @return 预占库存清算到0的skuId列表
     * @throws BizException 业务异常 {@link StockError},{@link OccupyError}
     * @deprecated 推荐使用
     * {@link RemoteStockOccupyService#rollbackOccupyStock(cn.com.duiba.cloud.stock.service.api.param.occupy.RollbackOccupyStockParam)}
     * {@link RemoteStockOccupyService#editOccupyStock(cn.com.duiba.cloud.stock.service.api.param.occupy.EditOccupyStockParam)}
     */
    @Deprecated
    List<Long> backOccupyStock(BackOccupyStockParam backOccupyStockParam) throws BizException;

    /**
     * 批量检查sku是否含有预占库存
     *
     * @param checkSkuHasOccupyParam 批量检查sku是否含有预占库存请求参数
     * @return 批量检查sku是否含有预占库存结果
     */
    List<CheckSkuHasOccupyDTO> checkSkuHasOccupy(CheckSkuHasOccupyParam checkSkuHasOccupyParam);

    /**
     * 根据skuId列表获取活动预占库存
     *
     * @param remoteActivityOccupyInfoParam 根据skuId列表获取活动预占库存请求参数
     * @return 预占列表库存信息
     */
    List<ActivityStockInfoDTO> listActivityOccupyGeneralInfo(
            RemoteActivityOccupyInfoParam remoteActivityOccupyInfoParam);

    /**
     * 根据活动id，批量获取sku的活动预占库存
     *
     * @param remoteGetActivityStockByActivityIdParam 根据活动id，批量获取sku的活动预占库存请求参数
     * @return skuId→活动预占库存
     */
    List<GetActivityStockByActivityIdDTO> getActivityStockByActivityId(
            RemoteGetActivityStockByActivityIdParam remoteGetActivityStockByActivityIdParam);

    /**
     * （兑吧删除活动）清除预占库存
     *
     * @param remoteClearOccupyStockParam 清除预占库存请求参数
     * @return true/false
     * @throws BizException 业务异常 {@link StockError}
     */
    Boolean clearOccupyStock(RemoteClearOccupyStockParam remoteClearOccupyStockParam) throws BizException;
}