package cn.com.duiba.cloud.stock.service.api.dto.lot;

import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 库存批次DTO
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @date 2022-04-24 20:14
 * @since 0.0.6
 **/
@Data
@Accessors(chain = true)
public class StockLotDTO implements Serializable {
    private static final long serialVersionUID = -9172138831419960736L;

    /**
     * skuId
     */
    private Long skuId;

    /**
     * skuId对应的库存批次
     */
    private List<StockLotSubDTO> stockLotSubDTOList;

    @Data
    @Accessors(chain = true)
    public static class StockLotSubDTO implements Serializable {
        private static final long serialVersionUID = -6129253509445043244L;

        /**
         * 库存批次id
         */
        private Long lotId;

        /**
         * 批次顺序
         */
        private Long lotSort;

        /**
         * 成本价
         */
        private Long costPrice;

        /**
         * 批次号
         */
        private Long lotNo;

        /**
         * 批次库存数量
         */
        private Long stockNumber;

        /**
         * 创建时间
         */
        private Date gmtCreate;

        /**
         * 修改时间
         */
        private Date gmtModified;
    }
}
