package cn.com.duiba.cloud.stock.service.api.param.occupy;

import cn.com.duiba.cloud.stock.service.api.enums.stock.StockOccupyEnum;
import cn.com.duiba.cloud.stock.service.api.param.BaseAppParam;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.List;

/**
 * 编辑预占库存请求参数
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 1.0
 * @date 2021/12/25 2:29 下午
 **/
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
public class EditOccupyStockParam extends BaseAppParam implements Serializable {
    private static final long serialVersionUID = 4662189102105166726L;

    /**
     * 调度作用域id 如活动id
     */
    @NotNull(message = "预占泛id不能为空")
    private Long generalId;

    /**
     * 调度作用域类型 {@link StockOccupyEnum}
     *
     * @deprecated 已废弃，给老积分商城做兼容，保留该字段
     */
    @Deprecated
    private Integer generalType;

    /**
     * 新增预占库存参数
     */
    @Valid
    @Size(min = 1, message = "新增预占库存参数最小必须为1")
    private List<AddOccupyStockParam> addOccupyStockParamList;

    /**
     * 变更预占库存参数
     */
    @Valid
    @Size(min = 1, message = "变更预占库存参数最小必须为1")
    private List<ChangeOccupyStockParam> changeOccupyStockParamList;

    /**
     * 清除的skuId列表
     */
    @Size(min = 1, message = "清除的skuId列表大小最小必须为1")
    private List<Long> cleanSkuIdList;

    @Data
    @Accessors(chain = true)
    public static class AddOccupyStockParam implements Serializable {
        private static final long serialVersionUID = 7022743239494569623L;

        /**
         * skuId
         */
        @NotNull(message = "skuId不能为空")
        private Long skuId;

        /**
         * 调度值<br>
         * ps：独占库存不能小于1
         */
        @NotNull(message = "预占库存数量不能为空")
        @Min(value = 0, message = "预占库存数量不能小于0")
        private Long dispatchValue;

        /**
         * sku货主应用id
         *
         * @deprecated 已废弃，给老积分商城做兼容，保留该字段
         */
        @Deprecated
        private Long sourceAppId;
    }

    @Data
    @Accessors(chain = true)
    public static class ChangeOccupyStockParam implements Serializable {
        private static final long serialVersionUID = -2711808867874266700L;

        /**
         * skuId
         */
        @NotNull(message = "skuId不能为空")
        private Long skuId;

        /**
         * 更新值
         */
        @NotNull(message = "变更值不能为空")
        private Long changeValue;

        /**
         * sku货主应用id
         *
         * @deprecated 已废弃，给老积分商城做兼容，保留该字段
         */
        @Deprecated
        private Long sourceAppId;
    }
}
