package cn.com.duiba.cloud.stock.service.api.param.occupy;

import cn.com.duiba.cloud.stock.service.api.param.BaseAppParam;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.List;

/**
 * （兑吧删除活动）清除预占库存请求参数
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @date 2022-04-20 11:46
 * @since 0.0.6
 **/
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
public class RemoteClearOccupyStockParam extends BaseAppParam implements Serializable {
    private static final long serialVersionUID = -114585024844075710L;

    /**
     * 需要清除预占库存的skuId列表
     */
    @NotNull
    @Size(min = 1, max = 100, message = "skuId列表大小必须在1-100之间")
    private List<Long> skuIdList;
}
