package cn.com.duiba.cloud.stock.service.api.param.stock;

import cn.com.duiba.cloud.stock.service.api.enums.stock.StockFlowTypeEnum;
import cn.com.duiba.cloud.stock.service.api.enums.stock.StockOccupyEnum;
import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.List;

/**
 * 消耗库存请求参数
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 1.0
 * @date 2021/11/25 4:52 下午
 **/
@Data
@Accessors(chain = true)
public class ConsumeStockParam implements Serializable {
    private static final long serialVersionUID = 7189730764651444236L;

    @Valid
    @NotNull(message = "消耗库存不能为空")
    @Size(min = 1, max = 20, message = "批量消耗库存大小必须在1-20之间")
    private List<ConsumeStockSubParam> consumeStockSubParamList;

    @Data
    @Accessors(chain = true)
    public static class ConsumeStockSubParam implements Serializable {
        private static final long serialVersionUID = -5715151934362507741L;

        /**
         * 应用ID
         */
        @NotNull(message = "应用id不能为空")
        private Long appId;

        /**
         * 预占场景泛id，如活动id<br>
         * 如果是预占消耗库存，必填
         */
        private Long generalId;

        /**
         * 预占场景泛类型，{@link StockOccupyEnum}<br>
         * 如果是预占消耗库存，必填
         */
        @Pattern(regexp = "^[1]$", message = "generalType的类型值只能为1")
        private String generalType;

        /**
         * skuId
         */
        @NotNull(message = "skuId不能为空")
        private Long skuId;

        /**
         * 库存变更值
         */
        @NotNull(message = "库存变更值不能为空")
        @Max(value = -1, message = "库存变更值最大只能为-1")
        private Long changeValue;

        /**
         * 业务单号
         */
        @NotBlank(message = "业务单号不能为空")
        private String bizNo;

        /**
         * 业务类型 {@link StockFlowTypeEnum}
         */
        @NotBlank(message = "业务类型不能为空")
        @Pattern(regexp = "^[15]$", message = "业务类型值只能为1和5")
        private String bizType;

        /**
         * 兑吧是否给开发者开启共享库存
         */
        @NotNull(message = "是否开启共享不能为空")
        private Boolean isEnabledShare;
    }
}