package cn.com.duiba.cloud.stock.service.api.enums.stock;

import cn.com.duiba.cloud.biz.tool.enums.IEnum;
import cn.hutool.core.collection.ListUtil;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.List;

/**
 * 库存预占类型枚举
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 1.0
 * @date 2021/11/25 2:21 下午
 **/
@Getter
@AllArgsConstructor
public enum StockOccupyEnum implements IEnum<Integer> {
    /**
     * 活动预占
     */
    ACTIVITY("活动", 1),

    /**
     * 独占
     */
    MONOPOLIZE("独占", 2),

    /**
     * 预采购
     *
     * @deprecated 已废弃，给老积分商城做兼容，保留该字段
     */
    @Deprecated
    PURCHASE("采购", 2),

    /**
     * 秒杀
     */
    SECKILL("秒杀", 3),

    /**
     * 星速台
     */
    PROJECTX("星速台", 4),
    ;

    /**
     * 描述
     */
    private String desc;

    /**
     * db值
     */
    private Integer dbCode;

    /**
     * 根据预占类型判断是否是活动预占（即非独占）
     *
     * @param type 预占类型
     * @return 是否是活动预占
     */
    public static boolean isOccupy(Integer type) {
        return ListUtil.list(false, ACTIVITY.getDbCode(), SECKILL.getDbCode(), PROJECTX.getDbCode())
                .contains(type);
    }

    public static final List<Integer> ACTIVITY_TYPES = ListUtil.list(false, ACTIVITY.getDbCode()
            , SECKILL.getDbCode(), PROJECTX.getDbCode());
}