package cn.com.duiba.cloud.stock.service.api.enums.stock;

import lombok.AllArgsConstructor;
import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * redisKey枚举
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @date 2021/12/20 10:34 下午
 * @since 0.0.1
 **/
@AllArgsConstructor
@Getter
public enum StockRedisKeyEnum {
    /**
     * 活动预占校验锁
     */
    K01("活动预占校验锁", "K01"),

    /**
     * 独占预占校验锁
     */
    K02("独占预占校验锁", "K02"),

    /**
     * 可用库存
     */
    K03("可用库存", "K03"),

    /**
     * 独占可用库存
     */
    K04("独占可用库存", "K04"),

    /**
     * saas活动预占可用库存
     */
    K05("saas活动预占可用库存", "K05"),

    /**
     * 秒杀预占可用库存
     */
    K06("秒杀预占可用库存", "K06"),

    /**
     * 星速台预占可用库存
     */
    K07("星速台预占可用库存", "K07"),
    ;

    /**
     * key前缀
     */
    public static final String PREFIX = "duiba-stock-service";

    private String desc;

    private String key;

    /**
     * 拼接key
     *
     * @param str 拼接字符串
     * @return 拼接后的key
     */
    public String join(Object... str) {
        return toString().concat(StringUtils.join(str, "_"));
    }

    /**
     * 拼接key前置
     */
    @Override
    public String toString() {
        return PREFIX + "_" + super.toString() + "_";
    }
}