package cn.com.duiba.cloud.stock.service.api.param.occupy;

import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.List;

/**
 * 批量仅查询独占库存值请求参数
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @date 2022-06-28 15:39
 * @since 0.0.9
 **/
@Data
@Accessors(chain = true)
public class RemoteBatchFindMonopolizeOnlyValueParam implements Serializable {
    private static final long serialVersionUID = 1660737709998378867L;

    /**
     * appId
     */
    @NotNull(message = "appId不能为空")
    private Long appId;

    /**
     * skuIdList
     */
    @NotNull(message = "skuId列表不能为空")
    @Size(min = 1, max = 100, message = "skuId列表大小必须在1-100之间")
    private List<Long> skuIdList;
}
