package cn.com.duiba.cloud.stock.service.api.param.occupy;

import cn.com.duiba.cloud.stock.service.api.param.BaseAppParam;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.List;

/**
 * 批量根据generalId获取库存请求参数
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @date 2022-05-05 16:23
 * @since 0.0.7
 **/
@Data
@EqualsAndHashCode(callSuper = true)
public class RemoteBatchGetStockByGeneralIdParam extends BaseAppParam implements Serializable {
    private static final long serialVersionUID = 6912414844040771791L;

    /**
     * generalId列表
     */
    @NotNull(message = "generalId列表不能为空")
    @Size(min = 1, max = 200, message = "generalId列表大小必须在1-200之间")
    private List<Long> generalIdList;
}
