package cn.com.duiba.cloud.stock.service.api.param.occupy;

import cn.com.duiba.cloud.stock.service.api.enums.stock.StockOccupyEnum;
import cn.com.duiba.cloud.stock.service.api.param.BaseAppParam;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.List;

/**
 * 编辑预占库存请求参数
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @date 2022-07-12 11:34
 * @since 0.1.0
 **/
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
public class RemoteEditOccupyStockV3Param extends BaseAppParam implements Serializable {
    private static final long serialVersionUID = 1736302999640915488L;

    /**
     * 预占类型
     *
     * @see StockOccupyEnum
     */
    @NotBlank(message = "预占类型不能为空")
    @Pattern(regexp = "^[134]$", message = "预占类型必须在1、3、4之间")
    private String generalType;

    /**
     * 新增预占库存参数
     */
    @Valid
    @Size(min = 1, message = "新增预占库存参数最小必须为1")
    private List<RemoteEditOccupyStockV3Param.AddOccupyStockParam> addOccupyStockParamList;

    /**
     * 变更预占库存参数
     */
    @Valid
    @Size(min = 1, message = "变更预占库存参数最小必须为1")
    private List<RemoteEditOccupyStockV3Param.ChangeOccupyStockParam> changeOccupyStockParamList;

    /**
     * 清除的generalId列表
     */
    @Size(min = 1, message = "清除的generalId列表大小最小必须为1")
    private List<Long> cleanGeneralIdList;

    @Data
    @Accessors(chain = true)
    public static class AddOccupyStockParam implements Serializable {
        private static final long serialVersionUID = 1782140952128878741L;

        /**
         * 调度作用域id，如奖品id
         */
        @NotNull(message = "预占泛id不能为空")
        private Long generalId;

        /**
         * skuId
         */
        @NotNull(message = "skuId不能为空")
        private Long skuId;

        /**
         * 调度值<br>
         * ps：独占库存不能小于1
         */
        @NotNull(message = "预占库存数量不能为空")
        @Min(value = 0, message = "预占库存数量不能小于0")
        private Long dispatchValue;

        /**
         * 附加id，如活动id
         */
        private Long additionId;
    }

    @Data
    @Accessors(chain = true)
    public static class ChangeOccupyStockParam implements Serializable {
        private static final long serialVersionUID = -7009353206244840254L;

        /**
         * 调度作用域id，如奖品id
         */
        @NotNull(message = "预占泛id不能为空")
        private Long generalId;

        /**
         * skuId
         */
        @NotNull(message = "skuId不能为空")
        private Long skuId;

        /**
         * 更新值
         */
        @NotNull(message = "变更值不能为空")
        private Long changeValue;
    }
}
