package cn.com.duiba.cloud.stock.service.api.param.occupy;

import cn.com.duiba.cloud.stock.service.api.param.BaseAppParam;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.List;

/**
 * 返还预占库存请求参数，不支持独占返还
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @date 2022-07-12 10:28
 * @since 0.1.0
 **/
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
public class RemoteRollbackOccupyStockParam extends BaseAppParam implements Serializable {
    private static final long serialVersionUID = 4651113805166190094L;

    /**
     * generalId列表
     */
    @NotNull(message = "generalId列表不能为空")
    @Size(min = 1, message = "generalId列表大小最小必须为1")
    private List<Long> generalIds;

    @NotBlank(message = "预占类型不能为空")
    @Pattern(regexp = "^[134]$", message = "预占类型必须在1、3、4之间")
    private String generalType;
}
