package cn.com.duiba.cloud.stock.service.api.param.stock;

import cn.com.duiba.cloud.stock.service.api.enums.stock.StockFlowStatusEnum;
import cn.com.duiba.cloud.stock.service.api.param.BaseAppParam;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;
import java.io.Serializable;

/**
 * 完成秒杀请求参数
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @date 2022-07-13 15:34
 * @since 0.1.0
 **/
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
public class RemoteCompleteSecKillParam extends BaseAppParam implements Serializable {
    private static final long serialVersionUID = 696446419603488846L;

    /**
     * 业务单号
     */
    @NotBlank(message = "业务单号不能为空")
    private String bizNo;

    /**
     * 变更的库存状态 {@link StockFlowStatusEnum}
     */
    @NotBlank(message = "库存流水状态不能为空")
    @Pattern(regexp = "^[234]$", message = "库存流水状态必须在2、3、4之间")
    private String stockStatus;
}
