package cn.com.duiba.cloud.stock.service.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.stock.service.api.dto.flow.StockFlowDTO;
import cn.com.duiba.cloud.stock.service.api.param.flow.RemoteStockFlowParam;
import cn.com.duiba.wolf.entity.PageResponse;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.util.List;

/**
 * 库存流水remote
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @since 0.0.3
 **/
@AdvancedFeignClient
public interface RemoteStockFlowService {
    /**
     * 根据业务单号查询库存流水
     *
     * @param bizNoList 业务单号列表
     * @return 库存流水
     */
    List<StockFlowDTO> findStockFlowByBizNo(@NotNull(message = "业务单号列表不能为空") @Size(min = 1, max = 20
            , message = "业务单号列表范围只能在1-20") List<String> bizNoList);

    /**
     * 根据skuId分页查询库存流水
     *
     * @param remoteStockFlowParam skuId分页参数
     * @return 库存流水
     */
    PageResponse<StockFlowDTO> findStockFlowBySkuId(RemoteStockFlowParam remoteStockFlowParam);
}