package cn.com.duiba.cloud.stock.service.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.stock.service.api.dto.occupy.ActivityStockInfoDTO;
import cn.com.duiba.cloud.stock.service.api.dto.occupy.CheckSkuHasOccupyDTO;
import cn.com.duiba.cloud.stock.service.api.dto.occupy.StockOccupyGeneralInfoDTO;
import cn.com.duiba.cloud.stock.service.api.dto.stock.GetActivityStockByActivityIdDTO;
import cn.com.duiba.cloud.stock.service.api.exception.OccupyError;
import cn.com.duiba.cloud.stock.service.api.exception.StockError;
import cn.com.duiba.cloud.stock.service.api.param.occupy.BackOccupyStockParam;
import cn.com.duiba.cloud.stock.service.api.param.occupy.CheckSkuHasOccupyParam;
import cn.com.duiba.cloud.stock.service.api.param.occupy.EditOccupyStockParam;
import cn.com.duiba.cloud.stock.service.api.param.occupy.RemoteActivityOccupyInfoParam;
import cn.com.duiba.cloud.stock.service.api.param.occupy.RemoteBatchGetStockByGeneralIdParam;
import cn.com.duiba.cloud.stock.service.api.param.occupy.RemoteClearOccupyStockParam;
import cn.com.duiba.cloud.stock.service.api.param.occupy.RemoteEditMonopolizeStockParam;
import cn.com.duiba.cloud.stock.service.api.param.occupy.RemoteEditOccupyStockParam;
import cn.com.duiba.cloud.stock.service.api.param.occupy.RemoteEditOccupyStockV3Param;
import cn.com.duiba.cloud.stock.service.api.param.occupy.RemoteGetActivityStockByActivityIdParam;
import cn.com.duiba.cloud.stock.service.api.param.occupy.RemoteRollbackOccupyStockParam;
import cn.com.duiba.cloud.stock.service.api.param.occupy.RollbackOccupyStockParam;
import cn.com.duiba.cloud.stock.service.api.param.occupy.StockOccupyGeneralInfoParam;
import cn.com.duiba.wolf.entity.PageResponse;

import java.util.List;

/**
 * 预占库存remote接口
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @date 2021/12/17 5:38 下午
 * @since 0.0.1
 **/
@AdvancedFeignClient
public interface RemoteStockOccupyService {

    /**
     * 根据预占场景id和类型返还并释放预占库存
     * <br>
     * 目前支持活动预占库存返还
     *
     * @param rollbackOccupyStockParam 返还预占库存请求参数
     * @return true/false
     * @throws BizException 业务异常 {@link StockError},{@link OccupyError}
     * @deprecated {@link #rollBackOccupyStockV2}
     */
    @Deprecated
    Boolean rollbackOccupyStock(RollbackOccupyStockParam rollbackOccupyStockParam) throws BizException;

    /**
     * 根据预占id和类型返还并释放预占库存
     * <br>
     * 支持saas活动、秒杀、星速台，不支持独占
     *
     * @param remoteRollbackOccupyStockParam 返还预占库存请求参数
     * @return true/false
     * @throws BizException 业务异常 {@link StockError},{@link OccupyError}
     */
    Boolean rollBackOccupyStockV2(RemoteRollbackOccupyStockParam remoteRollbackOccupyStockParam) throws BizException;

    /**
     * 编辑活动预占库存（老兑吧北现用）
     *
     * @param editOccupyStockParam 编辑预占库存请求参数
     * @return true/false
     * @throws BizException 业务异常 {@link StockError},{@link OccupyError}
     * @deprecated 老兑吧北现需求用，积分商城2.0使用新的
     * {@link #editOccupyStockV2}
     */
    @Deprecated
    Boolean editOccupyStock(EditOccupyStockParam editOccupyStockParam) throws BizException;

    /**
     * 编辑活动预占库存V2
     *
     * @param remoteEditOccupyStockParam 编辑活动预占库存请求参数
     * @return true/false
     * @throws BizException 业务异常 {@link StockError},{@link OccupyError}
     * @deprecated {@link #editOccupyStockV3}
     */
    @Deprecated
    Boolean editOccupyStockV2(RemoteEditOccupyStockParam remoteEditOccupyStockParam) throws BizException;

    /**
     * 通过预占类型编辑预占库存V3<br>
     * generalId在每个generalType下是唯一的
     *
     * @param remoteEditOccupyStockV3Param 编辑预占库存请求参数
     * @return true/false
     * @throws BizException 业务异常 {@link StockError},{@link OccupyError}
     */
    Boolean editOccupyStockV3(RemoteEditOccupyStockV3Param remoteEditOccupyStockV3Param) throws BizException;

    /**
     * 编辑独占库存
     *
     * @param remoteEditMonopolizeStockParam 编辑独占库存请求参数
     * @return true/false
     * @throws BizException 业务异常 {@link StockError},{@link OccupyError}
     */
    Boolean editMonopolizeStock(RemoteEditMonopolizeStockParam remoteEditMonopolizeStockParam) throws BizException;

    /**
     * 分页查询预占列表库存信息（包含冻结的库存）
     *
     * @param stockOccupyGeneralInfoParam 请求参数
     * @return 预占列表库存信息
     * @throws BizException 业务异常 {@link StockError},{@link OccupyError}
     */
    PageResponse<StockOccupyGeneralInfoDTO> pageListStockOccupyGeneralInfo(
            StockOccupyGeneralInfoParam stockOccupyGeneralInfoParam) throws BizException;

    /**
     * 返还预占库存<br>
     * 如果backValue为0，且库存中心存在预占库存，将会逻辑删除对应的预占库存
     *
     * @param backOccupyStockParam 返还预占库存请求参数
     * @return 预占库存清算到0的skuId列表
     * @throws BizException 业务异常 {@link StockError},{@link OccupyError}
     * @deprecated 推荐使用
     * {@link #rollBackOccupyStockV2}
     * {@link #editOccupyStock}
     */
    @Deprecated
    List<Long> backOccupyStock(BackOccupyStockParam backOccupyStockParam) throws BizException;

    /**
     * 批量检查sku是否含有预占库存（如果预占库存为0，但是没有释放，也属于预占）
     *
     * @param checkSkuHasOccupyParam 批量检查sku是否含有预占库存请求参数
     * @return 批量检查sku是否含有预占库存结果
     * @throws BizException 业务异常 {@link StockError#GET_STOCK_IS_NULL}
     */
    List<CheckSkuHasOccupyDTO> checkSkuHasOccupy(CheckSkuHasOccupyParam checkSkuHasOccupyParam) throws BizException;

    /**
     * 根据skuId列表获取活动预占库存（仅支持saas活动）
     *
     * @param remoteActivityOccupyInfoParam 根据skuId列表获取活动预占库存请求参数
     * @return 预占列表库存信息
     */
    List<ActivityStockInfoDTO> listActivityOccupyGeneralInfo(
            RemoteActivityOccupyInfoParam remoteActivityOccupyInfoParam);

    /**
     * 根据活动id，批量获取sku的活动预占库存
     *
     * @param remoteGetActivityStockByActivityIdParam 根据活动id，批量获取sku的活动预占库存请求参数
     * @return skuId→活动预占库存
     * @deprecated {@link #batchGetStockByGeneralId}
     */
    @Deprecated
    List<GetActivityStockByActivityIdDTO> getActivityStockByActivityId(
            RemoteGetActivityStockByActivityIdParam remoteGetActivityStockByActivityIdParam);

    /**
     * （根据appId）清除appId下的预占库存<br>
     * 如果appId是兑吧（0）的话，就是清除sku下面所有的预占库存
     *
     * @param remoteClearOccupyStockParam 清除预占库存请求参数
     * @return true/false
     * @throws BizException 业务异常 {@link StockError}
     */
    Boolean clearOccupyStock(RemoteClearOccupyStockParam remoteClearOccupyStockParam) throws BizException;

    /**
     * 批量通过generalId获取预占库存<br>
     * 如果传参中的generalId没有查询到对应库存，返回结果也对应不会追加
     *
     * @param remoteBatchGetStockByGeneralIdParam 批量根据generalId获取库存请求参数
     * @return 预占列表库存信息
     * @throws BizException 业务异常 {@link StockError}
     */
    List<StockOccupyGeneralInfoDTO> batchGetStockByGeneralId(
            RemoteBatchGetStockByGeneralIdParam remoteBatchGetStockByGeneralIdParam) throws BizException;
}