package cn.com.duiba.cloud.duiba.supplier.executor.api.model.dto;

import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * @author yuanzhixin
 * @version 1.0
 * @date 2021/12/29 10:10
 */
@Getter
@Setter
public class JDCalendarListDTO implements Serializable {

    /**
     * 状态，只有1表示处理成功
     */
    private Integer resultCode;

    /**
     * 对resultCode的简要说明
     */
    private String resultMessage;

    /**
     * <pre>
     * 履约时间
     * 1、只工作日送货(双休日、假日不用送)
     * 2、只双休日、假日送货(工作日不用送)
     * 3、工作日、双休日与假日均可送货
     * Sting里面放置返回的promise字符串（包括html语句）；若没有，则返回空字符串
     * 有预约日历时，才有值
     * </pre>
     */
    private Map<Integer, String> promiseTime;

    /**
     * <pre>
     * 提示信息
     * 311区域：“配送服务升级，晚间也可以送货上门啦！”
     * 211和次日达区域：“配送服务升级，可以指定上午和下午送货上门啦！
     * </pre>
     */
    private String tipMsg;

    /**
     * 中小件预约日历的详细信息：
     */
    private List<JDCalendarDayDTO> calendarList;
}
