package cn.com.duiba.cloud.duiba.supplier.executor.api.model.param;

import lombok.Builder;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @author yuanzhixin
 * @version 1.0
 * @date 2021/12/29 09:57
 */
@Getter
@Setter
@Builder
public class RemoteJDPromiseCalendarParam implements Serializable {

    /**
     * 京东支付方式
     */
    @NotNull(message = "paymentType 不能为空")
    private Integer paymentType;

    /**
     * <pre>
     *   [{"skuId":商品编号1,"num":商品数量1},{"skuId":商品编号2,"num":商品数量2}]
     * </pre>
     */
    @NotNull(message = "sku 不能为空")
    private List<RemoteJDSkuParam> sku;

    /**
     * geoId
     */
    @NotNull(message = "geoId 不能为空")
    private String geoId;

    /**
     * 省市县区地址
     */
    @NotBlank(message = "localAddress 不能为空")
    private String localAddress;
}
