package cn.com.duiba.cloud.manage.service.api.remoteservice.app;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.manage.service.api.model.dto.app.AppDetailDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.app.TenantAppDTO;
import cn.com.duiba.cloud.manage.service.api.model.param.app.RemoteAppSecretQueryParam;
import cn.com.duiba.cloud.manage.service.api.model.param.app.RemoteGetTenantAppParam;

import java.util.List;

/**
 * 应用服务
 *
 * @author jiangyesheng
 * @version 1.0
 * @date 2022/6/6
 */
@AdvancedFeignClient
public interface RemoteAppService {

    /**
     * 获取租户订阅应用信息
     * 兼容 -> 参数无用
     *
     * @param param
     * @return
     * @throws BizException
     */
    List<TenantAppDTO> getTenantApp(RemoteGetTenantAppParam param) throws BizException;

    /**
     * 根据appKey查询appSecret（内部方法）
     * 兼容 -> 参数无用
     *
     * @param param appKey
     * @return AppDetailDTO
     * @throws BizException 校验参数异常
     */
    AppDetailDTO getAppSecret(RemoteAppSecretQueryParam param) throws BizException;

}
