package cn.com.duiba.cloud.manage.service.api.model.enums.exception;

/**
 * @author linzhou
 * @version 1.0.0
 * @ClassName ErrorCode.java
 * @Description 异常返回枚举
 * @createTime 2021年07月14日 14:55:00
 */
public enum ErrorCode {
    /**
     * 999开头为系统级异常
     */
    ERROR("999999", "未知异常"),
    REQUEST_FREQUENTLY("999998", "请求过于频繁，请稍后再试"),
    DATA_ERROR("999997", "数据异常，请联系管理员"),
    NEED_LONGIN("000000","请先登录"),
    UNKNOWN_OPERATOR("0000001", "未知操作人"),
    FAULTY_PAGINATION_PARAM("0000002", "不正确的分页参数"),
    PARAM_IS_NOT_NULL("0000003", "必填参数不能为空"),
    TENANT_COOKIE_INVALID("0000004", "租户cookie已失效"),
    UPDATE_TEL_FAIL("0000005", "手机号已注册，请重新输入"),
    FILE_NOT_EXISTS("0000006", "文件不存在"),
    UPLOAD_EXCEL_FILE("0000007", "请上传正确的EXCEL文件，以.xls或.xlsx结尾"),
    ERROR_PARAM("0000008", "参数错误"),
    PARAM_NOT_SPECIFICATION("0000009", "[]字段输入不合规"),
    CAPTCHA_ERROR("0000010", "图片验证码错误"),
    EMAIL_ERROR("0000011", "邮箱格式错误"),
    CAPTCHA_VALIDATE_FAIL("0000012", "验证码校验不通过"),
    ENUM_UTIL_GET_FIELD_IS_NULL("0000013", "枚举类错误,请添加Code注解或命名字段为code"),
    QUERY_DAY_OUT_OF_RANGE("0000014", "只能查询最近[]天的数据"),
    MOBILE_ERROR("0000015", "手机号格式错误"),
    USER_ID_NOT_NULL("0000016", "用户id不能为空"),

    //================租户开始100开头================================
    TENANT_NOT_NULL("100001", "请先选择租户"),
    TENANT_NAME_EXIST("100002", "租户名称已存在"),
    TENANT_NAME_NOT_BLANK("100003", "租户名称不能为空"),
    TENANT_NOT_EXIST("100004", "租户不存在"),
    TENANT_CREATE_LIMIT("100005", "租户创建已达上限"),
    TENANT_SAVE_FAIL("100006", "保存租户失败"),
    TENANT_UPDATE_FAIL("100007", "更新租户失败"),
    RS_TENANT_IS_EXIST("100008", "已邀请[],不需要重复邀请"),
    RS_TENANT_NOT_EXIST("100009", "未找到租户关联关系"),
    RS_TENANT_NOT_STATE("1000010", "租户关联关系状态不合法"),
    RS_TENANT_STATE_NOT_CHANGE("1000011", "租户关联关系状态为[],不允许操作"),
    RS_TENANT_TO_ID_ERROR("1000011", "不允许操作其他租户的关联关系"),


    //================租户结束======================================



    //================部门开始101开头================================
    /**
     * 部门名称不能为空
     */
    DEPT_NAME_NOT_BLANK("101001", "部门名称不能为空"),
    CHILD_DEPT_IS_MAX("101002", "子部门数量已经达到最大值,无法继续创建"),
    DEPT_NAME_EXIST("101003", "部门名称已存在"),
    CHILD_DEPT_LEVEL_MAX("101004", "最多可以创建[]级子部门"),
    DEPT_NOT_EXIST("101005", "部门不存在"),
    DEPT_STAFF_EXIST("101006", "部门下存在有效用户，无法删除"),
    P_DEPT_ID_NOT_NULL("101007", "上级部门id不能为空"),
    DEPT_NOT_NULL("101008", "部门不能为空"),
    DEPT_NULL_NOT_EXIST("101009", "部门名称[]不存在"),
    PARENT_DEPT_NOT_SELF("101010", "上级部门不能是自身"),
    PARENT_DEPT_FOR("101011", "部门上下级发生循环"),
    DEPT_STAFF_IDENTIFY_NOT_EXIST("101012", "部门员工身份不存在"),
    P_DEPT_ID_IS_NULL("1010013", "上级部门[id]不存在"),
    //================部门结束======================================

    //================角色开始102开头================================
    ROLE_ID_NOT_NULL("102001", "角色id不能为空"),
    ROLE_NAME_NOT_BLANK("102002", "角色名称不能为空"),
    ROLE_NOT_EXISTS("102003", "角色信息不存在"),
    DEFAULT_ROLE_CAN_NOT_DELETE("102004", "不允许删除默认角色"),
    ROLE_HAS_STAFF("102005", "所删除角色下存在用户，请删除用户后再尝试"),
    DEFAULT_ROLE_CAN_NOT_UPDATE("102006", "不允许操作默认角色"),
    ROLE_NAME_REPEAT("102007", "角色名称重复"),
    ROLE_NOT_NULL("102008", "角色不能为空"),
    ROLE_NAME_NOT_EXISTS("102009", "角色名称[]不存在"),
    ROLE_EXISTS_STAFF("102010", "员工已存在该角色"),
    DEFAULT_APP_DEFAULT_ROLE_CAN_NOT_UPDATE("102011", "不允许操作默认应用中的默认角色"),

    ROLE_AUTH_INSERT_FAIL("102198", "角色权限信息创建失败"),
    ROLE_UPDATE_FAIL("102097", "角色更新失败"),
    ROLE_INSERT_FAIL("102098", "角色创建失败"),
    ROLE_DELETE_FAIL("102099", "角色删除失败"),
    //================角色结束======================================

    //================员工开始103开头================================
    STAFF_NOT_EXIST("103001", "员工不存在"),
    STAFF_IS_NULL("103002", "未选择员工"),
    ADMINISTRATOR_NOT_EXIST("103003", "管理员不存在"),
    STAFF_IS_EXIST("103004", "人员已存在，可于“人员详情”中修改"),
    STAFF_INVITE_RECORD_IS_EXIST("103005", "员工已经邀请"),
    STAFF_UPDATE_TEL_FAIL("103006", "更新手机号失败"),
    STAFF_SAVE_FAIL("103007", "保存租户员工失败"),
    STAFF_UPDATE_FAIL("103008", "更新租户员工失败"),
    STAFF_EXIT_FAIL("103009", "退出租户失败"),
    ADMIN_STAFF_NOT_DEL("103010", "管理员不允许被删除"),
    STAFF_INVITE_NOT_EXIST("103011", "员工邀请不存在"),
    STAFF_INVITE_NOT_USE("103012", "员工邀请已失效"),
    DUPLICATE_STAFF("103013", "员工选择重复"),
    ADMINISTRATOR_CAN_NOT_EXIT("103014", "管理员不允许退出企业"),
    STAFF_POSITION_NAME_TOO_LONG("103015", "员工岗位名称字段过长，须小于[]个字符!"),
    DEPT_NAMES_TOO_LONG("103016", "部门字段信息过长，须小于[]个字符!"),
    STAFF_USER_ID_TOO_LONG("103017", "员工编号字段信息过长，须小于[]个字符!"),
    STAFF_NAME_TOO_LONG("103018", "员工名称字段信息过长，须小于[]个字符!"),
    STAFF_LEAST_NEED_ONE_ROLE("103019", "员工至少需要保留一个角色"),
    STAFF_INVITE_CANCEL_ERROR("103020", "只有未反馈的状态才可以取消邀请"),
    STAFF_INVITE_RE_ERROR("103021", "只有拒绝和取消状态的才可以重新邀请"),

    STAFF_ROLE_INSERT_FAIL("103198", "角色员工添加失败"),
    STAFF_ROLE_DELETE_FAIL("103199", "角色员工删除失败"),
    //================员工结束======================================

    //================应用开始104开头================================
    APP_ID_NOT_NULL("104001", "应用id不能为空"),
    APP_CODE_NOT_BLANK("104002", "应用code不能为空"),
    APP_SUBSCRIBE_FAIL("104003", "应用订阅失败"),
    APP_NOT_EXISTS("104004", "应用不存在"),
    APP_AUTH_NOT_BLANK("104005", "应用权限不能为空"),
    DUPLICATE_APP("104006", "请勿选择重复应用"),
    TENANT_NOT_SUBSCRIBE_APP("104007", "租户未订阅应用"),
    TENANT_APP_NAME_NOT_BLANK("104008", "应用名称不能为空"),
    TENANT_APP_ID_NOT_NULL("104009", "租户应用ID不能为空"),
    APP_NOT_CHOOSE("104010", "请先选择应用"),
    CANT_SUBSCRIBE_DEFAULT_APP("104011", "不可订阅默认应用"),
    APP_NAME_LENGTH_OVER_LIMIT("104012", "应用名称长度超出限制"),
    APP_SUBSCRIBE_TO_LIMIT("104013", "应用订阅已达上限"),

    //================应用结束======================================

    //================邀请记录开始105开头================================
    INVITE_NOT_EXIST("105001", "邀请记录不存在"),
    ACCEPT_INVITE_FAIL("105002", "接受邀请失败"),
    REJECT_INVITE_FAIL("105003", "拒绝邀请失败"),
    STAFF_INVITE_REMAKE_TOO_LONG("105004", "备注必须小于[50]个字符"),

    //================应用结束======================================

    //================权限开始106开头================================
    AUTH_ID_NOT_NULL("106001", "权限id不能为空"),
    AUTH_CODE_NOT_BLANK("106002", "权限code不能为空"),
    AUTH_NAME_NOT_BLANK("106003", "权限名称不能为空"),
    AUTH_TYPE_NOT_RIGHT("106004", "权限类型不正确"),
    AUTH_CODE_EXISTS("106005", "当前应用权限code已存在"),
    AUTH_NAME_EXISTS("106006", "同级别权限name已存在"),
    AUTH_NOT_EXISTS("106007", "权限不存在"),
    HAS_SUB_AUTH("106008", "存在子权限，不可删除"),
    AUTH_LIST_NOT_NULL("106009", "权限列表不能为空"),
    AUTH_SORT_NOT_NULL("106010", "权限序号不能为空"),
    PARENT_AUTH_NOT_EXISTS("106011", "父级权限不存在"),
    DUPLICATE_AUTH("106012", "权限重复"),
    APP_DEFAULT_RIGHTS_PKG_NOT_EXISTS("106013", "未配置当前应用默认权益包，请联系管理员"),

    AUTH_DELETE_FAIL("106197", "删除权限失败"),
    AUTH_INSERT_FAIL("106198", "新增权限失败"),
    AUTH_UPDATE_FAIL("106199", "权限更新失败"),
    //================权限结束======================================
    //================文件导入开始107开头================================
    HANDLER_IS_NULL("107001", "暂不支持导入,导入类型[]"),
    IMPORT_DATA_TYPE_IS_NULL("107002", "暂不支持导入"),
    //================文件导入结束======================================
    //================文件导入开始108开头================================
    USER_IS_NULL("108001", "用户不存在,请先注册"),
    PHONE_NOT_REGISTER("108002", "人员手机号码未注册"),
    PHONE_DUPLICATE("108003", "人员手机号码重复"),
    USER_NOT_BELONG_TENANT("108004", "非本企业人员"),
    PHONE_IS_BLANK("108005", "人员手机号码为空"),
    NAME_IS_BLANK("108006", "人员名为空"),
    DATA_IS_EMPTY("108009", "没有查询到可以导出的数据"),
    //================文件导入结束======================================
    //================权益开始109开头================================
    RIGHTS_NAME_NOT_BLANK("109001", "权益名称不能为空"),
    RIGHTS_CODE_NOT_BLANK("109002", "权益code不能为空"),
    RIGHTS_LEVEL_NOT_BLANK("109003", "权益优先级不能为空"),
    DUPLICATE_RIGHTS_LEVEL("109004", "相同权益code不可存在相同的level"),
    DUPLICATE_RIGHTS_NAME("109005", "同级别下权益名称不允许重复"),
    RIGHTS_ID_NOT_NULL("109006", "权益id不能为空"),
    RIGHTS_NOT_EXISTS("109007", "权益不存在"),
    HAS_SON_RIGHTS("109008", "存在子权益，不可删除"),
    PARENTS_ID_NOT_EXISTS("109009", "父权益不存在"),
    RIGHTS_INFO_NOT_EMPTY("109010", "权益信息不能为空"),
    RIGHTS_SORT_NOT_NULL("109011", "权益序号不能为空"),
    RIGHTS_IS_ALREADY_SUBSCRIBE("109012", "权益已被订阅"),

    RIGHTS_AUTH_SAVE_FAIL("109089", "权益权限保存失败"),
    RIGHTS_SAVE_FAIL("109099", "权益保存失败"),
    RIGHTS_UPDATE_FAIL("109098", "权益更新失败"),
    RIGHTS_DELETE_FAIL("109097", "权益删除失败"),
    //================权益导入结束======================================
    //================数据字典开始110开头================================
    DICTIONARY_TYPE_ERROR("110001", "数据字典类型错误"),
    DICTIONARY_INDUSTRY_IS_NULL("110002", "行业不存在"),

    //================数据字典结束======================================
    //================供应商开始111开头================================
    CHECK_GOODS_STATUS_ERROR("111001", "审核商品状态异常"),

    //================供应商结束======================================



    ;

    private String code;

    private String msg;

    ErrorCode(String code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }
}
