package cn.com.duiba.cloud.manage.service.api.remoteservice.app;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.manage.service.api.model.dto.app.AppTypeDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.app.TenantAppDTO;
import cn.com.duiba.cloud.manage.service.api.model.param.app.RemoteAppSecretQueryParam;
import cn.com.duiba.cloud.manage.service.api.model.param.app.RemoteCheckSubscribeParam;
import cn.com.duiba.cloud.manage.service.api.model.param.app.RemoteDefaultTenantAppIdQueryParam;
import cn.com.duiba.cloud.manage.service.api.model.param.app.RemoteGetTenantAppParam;
import cn.com.duiba.cloud.manage.service.api.model.param.app.RemoteSubscribeAppParam;
import cn.com.duiba.cloud.manage.service.api.model.param.app.RemoteSubscribeQueryParam;
import cn.com.duiba.cloud.manage.service.api.model.param.app.RemoteSubscribedAppParam;

import java.util.List;

/**
 * @author yuanzhixin
 * @version 1.0
 * @description
 * @date 2021/12/27 09:58
 */
@AdvancedFeignClient
public interface RemoteAppService {

    /**
     * <pre>
     * 创建应用订阅关系
     * </pre>
     * @param param 订阅参数
     * @throws BizException 订阅应用异常
     */
    void subscribeApp(RemoteSubscribeAppParam param) throws BizException;

    /**
     * <pre>
     * 查询应用类型
     * </pre>
     * @return List<AppTypeVO>
     */
    List<AppTypeDTO> getTypeList();

    /**
     * <pre>
     * 查询已订阅的应用
     * </pre>
     * @param param 租户id
     * @return List<AppVO>
     */
    List<TenantAppDTO> getList(RemoteSubscribedAppParam param) throws BizException;

    /**
     * <pre>
     *     判断是否已订阅应用
     * </pre>
     * @param param 应用id
     * @return 是否已订阅应用
     * @throws BizException 校验参数异常
     */
    Boolean isSubscribeApp(RemoteCheckSubscribeParam param) throws BizException;

    /**
     * <pre>
     *     查询订阅关系id
     * </pre>
     * @param param 应用id
     * @return 订阅关系id
     * @throws BizException 校验参数异常
     */
    Long getTenantAppId(RemoteSubscribeQueryParam param) throws BizException;

    /**
     * 根据appKey查询appSecret
     * @param param appKey
     * @return appSecret
     * @throws BizException 校验参数异常
     */
    String getAppSecret(RemoteAppSecretQueryParam param) throws BizException;

    /**
     * 获取默认租户应用id
     * @param param
     * @return
     * @throws BizException
     */
    Long getDefaultTenantAppId(RemoteDefaultTenantAppIdQueryParam param) throws BizException;

    /**
     * 获取租户订阅应用信息 - 目前就查了个别名
     * @param param
     * @return
     * @throws BizException
     */
    List<TenantAppDTO> getTenantApp(RemoteGetTenantAppParam param) throws BizException;
}
