package cn.com.duiba.cloud.manage.service.api.model.dto.mallapp;

import lombok.Data;

import java.io.Serializable;

/**
 * @author: 郑建豪
 * @date: 2022/3/28 15:53
 * @description: 商城应用兑吧管理后台配置
 */
@Data
public class MallAppDuibaConfDTO implements Serializable {

    private static final long serialVersionUID = -9218237879190591461L;

    /**
     * 主键id
     */
    private Long id;

    /**
     * 商城应用id
     */
    private Long appId;

    /**
     * 关联积分你上次1.0appid
     */
    private Long relateAppId;

    /**
     * 关联应用名称
     */
    private String relateAppName;

    /**
     * 关联app的appKey
     */
    private String appKey;

    /**
     * 关联app的appSecret
     */
    private String appSecret;

    /**
     * 是否展示兑吧提供技术支持文案：0，不开启；1，开启
     */
    private Integer showTechnicalSupport;

    /**
     * 导航栏代码
     */
    private String navProgram;

    /**
     * 全局js配置
     */
    private String globalJs;
    /**
     *下拉限制 0否1是
     */
    private Integer dropDownLimit;
    /**
     * 推送开关，第0位：待支付，第1位：已支付，第2位：待审核，第3位：待发货，第4位：交易完成，第5位：异常状态，第6位：交易成功，第7位：交易关闭
     */
    private Long pushPerm;
}