package cn.com.duiba.cloud.manage.service.api.model.enums.app;

/**
 * @Author: fss
 * @Date: 2022/6/1 16
 * @Description: 推送开关位
 */
public enum AppOrderPushEnum {


    WAIT_PAY_PUSH(0, "待支付推送"),
    PAID_PUSH(1, "已支付推送"),
    WAIT_REVIEW_PUSH(2, "待审核推送"),
    WAIT_SHIPMENT_PUSH(3, "待发货推送"),
//    WAIT_TAKE_DELIVERY_PUSH(4, "待收货推送"),
    ORDER_COMPLETION_PUSH(4, "交易完成推送"),

    ORDER_ERROR_PUSH(5, "异常状态推送"),

    ORDER_SUCCESS_PUSH(6, "交易成功推送"),
    ORDER_CLOSE_PUSH(7, "交易关闭推送"),
    ;

    private final int operType;
    private final String desc;

    AppOrderPushEnum(int operType, String desc) {
        this.operType = operType;
        this.desc = desc;
    }

    public int getMode() {
        return operType;
    }

    public String getDesc() {
        return desc;
    }
}
